"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ackWatch = ackWatch;
exports.ackWatchRoute = ackWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function ackWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          watchId,
          actionId
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      let path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack`;
      if (actionId) {
        path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack/${actionId}`;
      }
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'put',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`ackWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function ackWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.WATCH}/{watchId}/_ack/{actionId?}`,
    validate: {
      params: _configSchema.schema.object({
        watchId: _configSchema.schema.string(),
        actionId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, ackWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9lcnJvcnMiLCJfY29uc3RhbnRzIiwiYWNrV2F0Y2giLCJjbHVzdGVyQ2xpZW50IiwibG9nZ2VyIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsInBhcmFtcyIsIndhdGNoSWQiLCJhY3Rpb25JZCIsImhlYWRlcnMiLCJzZ3RlbmFudCIsIk5PX01VTFRJVEVOQU5DWV9URU5BTlQiLCJwYXRoIiwiZW5jb2RlVVJJQ29tcG9uZW50IiwicmVzcCIsImFzU2NvcGVkIiwiYXNDdXJyZW50VXNlciIsInRyYW5zcG9ydCIsIm1ldGhvZCIsIm9rIiwiYm9keSIsImVyciIsImVycm9yIiwic3RhY2siLCJjdXN0b21FcnJvciIsInNlcnZlckVycm9yIiwiYWNrV2F0Y2hSb3V0ZSIsInJvdXRlciIsInB1dCIsIlJPVVRFX1BBVEgiLCJXQVRDSCIsInZhbGlkYXRlIiwic2NoZW1hIiwib2JqZWN0Iiwic3RyaW5nIiwibWF5YmUiXSwic291cmNlcyI6WyJhY2suanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgIENvcHlyaWdodCAyMDIwIGZsb3JhZ3VubiBHbWJIXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQGtibi9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IHNlcnZlckVycm9yIH0gZnJvbSAnLi4vLi4vbGliL2Vycm9ycyc7XG5pbXBvcnQgeyBST1VURV9QQVRILCBOT19NVUxUSVRFTkFOQ1lfVEVOQU5UIH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vY29tbW9uL3NpZ25hbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGFja1dhdGNoKHsgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pIHtcbiAgcmV0dXJuIGFzeW5jIGZ1bmN0aW9uIChjb250ZXh0LCByZXF1ZXN0LCByZXNwb25zZSkge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHBhcmFtczogeyB3YXRjaElkLCBhY3Rpb25JZCB9LFxuICAgICAgICBoZWFkZXJzOiB7IHNndGVuYW50ID0gTk9fTVVMVElURU5BTkNZX1RFTkFOVCB9LFxuICAgICAgfSA9IHJlcXVlc3Q7XG5cbiAgICAgIGxldCBwYXRoID0gYC9fc2lnbmFscy93YXRjaC8ke2VuY29kZVVSSUNvbXBvbmVudChzZ3RlbmFudCl9LyR7ZW5jb2RlVVJJQ29tcG9uZW50KHdhdGNoSWQpfS9fYWNrYDtcbiAgICAgIGlmIChhY3Rpb25JZCkge1xuICAgICAgICBwYXRoID0gYC9fc2lnbmFscy93YXRjaC8ke2VuY29kZVVSSUNvbXBvbmVudChzZ3RlbmFudCl9LyR7ZW5jb2RlVVJJQ29tcG9uZW50KHdhdGNoSWQpfS9fYWNrLyR7YWN0aW9uSWR9YDtcbiAgICAgIH1cblxuICAgICAgY29uc3QgcmVzcCA9IGF3YWl0IGNsdXN0ZXJDbGllbnQuYXNTY29wZWQocmVxdWVzdCkuYXNDdXJyZW50VXNlci50cmFuc3BvcnQucmVxdWVzdCh7XG4gICAgICAgIG1ldGhvZDogJ3B1dCcsXG4gICAgICAgIHBhdGgsXG4gICAgICB9KTtcblxuICAgICAgcmV0dXJuIHJlc3BvbnNlLm9rKHtcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3AsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGxvZ2dlci5lcnJvcihgYWNrV2F0Y2g6ICR7ZXJyLnN0YWNrfWApO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbUVycm9yKHNlcnZlckVycm9yKGVycikpO1xuICAgIH1cbiAgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFja1dhdGNoUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KSB7XG4gIHJvdXRlci5wdXQoXG4gICAge1xuICAgICAgcGF0aDogYCR7Uk9VVEVfUEFUSC5XQVRDSH0ve3dhdGNoSWR9L19hY2sve2FjdGlvbklkP31gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICB3YXRjaElkOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgYWN0aW9uSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhY2tXYXRjaCh7IGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBZ0JBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLE9BQUEsR0FBQUQsT0FBQTtBQUNBLElBQUFFLFVBQUEsR0FBQUYsT0FBQTtBQWxCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBTU8sU0FBU0csUUFBUUEsQ0FBQztFQUFFQyxhQUFhO0VBQUVDO0FBQU8sQ0FBQyxFQUFFO0VBQ2xELE9BQU8sZ0JBQWdCQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsUUFBUSxFQUFFO0lBQ2pELElBQUk7TUFDRixNQUFNO1FBQ0pDLE1BQU0sRUFBRTtVQUFFQyxPQUFPO1VBQUVDO1FBQVMsQ0FBQztRQUM3QkMsT0FBTyxFQUFFO1VBQUVDLFFBQVEsR0FBR0M7UUFBdUI7TUFDL0MsQ0FBQyxHQUFHUCxPQUFPO01BRVgsSUFBSVEsSUFBSSxHQUFJLG1CQUFrQkMsa0JBQWtCLENBQUNILFFBQVEsQ0FBRSxJQUFHRyxrQkFBa0IsQ0FBQ04sT0FBTyxDQUFFLE9BQU07TUFDaEcsSUFBSUMsUUFBUSxFQUFFO1FBQ1pJLElBQUksR0FBSSxtQkFBa0JDLGtCQUFrQixDQUFDSCxRQUFRLENBQUUsSUFBR0csa0JBQWtCLENBQUNOLE9BQU8sQ0FBRSxTQUFRQyxRQUFTLEVBQUM7TUFDMUc7TUFFQSxNQUFNTSxJQUFJLEdBQUcsTUFBTWIsYUFBYSxDQUFDYyxRQUFRLENBQUNYLE9BQU8sQ0FBQyxDQUFDWSxhQUFhLENBQUNDLFNBQVMsQ0FBQ2IsT0FBTyxDQUFDO1FBQ2pGYyxNQUFNLEVBQUUsS0FBSztRQUNiTjtNQUNGLENBQUMsQ0FBQztNQUVGLE9BQU9QLFFBQVEsQ0FBQ2MsRUFBRSxDQUFDO1FBQ2pCQyxJQUFJLEVBQUU7VUFDSkQsRUFBRSxFQUFFLElBQUk7VUFDUkw7UUFDRjtNQUNGLENBQUMsQ0FBQztJQUNKLENBQUMsQ0FBQyxPQUFPTyxHQUFHLEVBQUU7TUFDWm5CLE1BQU0sQ0FBQ29CLEtBQUssQ0FBRSxhQUFZRCxHQUFHLENBQUNFLEtBQU0sRUFBQyxDQUFDO01BQ3RDLE9BQU9sQixRQUFRLENBQUNtQixXQUFXLENBQUMsSUFBQUMsbUJBQVcsRUFBQ0osR0FBRyxDQUFDLENBQUM7SUFDL0M7RUFDRixDQUFDO0FBQ0g7QUFFTyxTQUFTSyxhQUFhQSxDQUFDO0VBQUVDLE1BQU07RUFBRTFCLGFBQWE7RUFBRUM7QUFBTyxDQUFDLEVBQUU7RUFDL0R5QixNQUFNLENBQUNDLEdBQUcsQ0FDUjtJQUNFaEIsSUFBSSxFQUFHLEdBQUVpQixxQkFBVSxDQUFDQyxLQUFNLDZCQUE0QjtJQUN0REMsUUFBUSxFQUFFO01BQ1J6QixNQUFNLEVBQUUwQixvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDcEIxQixPQUFPLEVBQUV5QixvQkFBTSxDQUFDRSxNQUFNLEVBQUU7UUFDeEIxQixRQUFRLEVBQUV3QixvQkFBTSxDQUFDRyxLQUFLLENBQUNILG9CQUFNLENBQUNFLE1BQU0sRUFBRTtNQUN4QyxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0RsQyxRQUFRLENBQUM7SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FBQyxDQUNwQztBQUNIIn0=